



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Internationale sider</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">13 <a name='afsn13'></a>Internationale
sider</H1>
<DIV ID="Indholdsfortegnelse18">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.1
  Internationale programmer  263</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.1.1
  Formatering af tidspunkter  263</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.1.2
  Formatering af tal og bel&oslash;b  264</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.1.3
  Bruge Locale-objekter  264</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.1.4
  De mulige lokalindstillinger  265</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.2
  Eksempel: Webside med alle sprog  266</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.3
  Tegns&aelig;t og HTML-entiteter  268</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.4
  Tekstindhold i resursefiler  268</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.4.1
  Hvordan der s&oslash;ges efter resurser  269</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.4.2
  Avanceret: Bin&aelig;re resursefiler  270</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.4.3
  Avanceret tekstformatering  270</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.5
  En international f&aelig;lleskalender  272</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.5.1
  Slutbrugerens oplevelse  272</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">13.5.2
  Fuld separation mellem layout og sprog  273</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>13.6
  Yderligere l&aelig;sning  276</B></FONT></FONT></P>
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
</DIV>















<P CLASS="kapiteloversigt-western"><SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none">Dette
kapitel </SPAN></SPAN>foruds&aelig;tter <a href='kapitel9.jsp'>kapitel 9</a>, Javab&oslash;nner i JSP-sider.</P>
<H2 CLASS="western" STYLE="">13.1 <a name='afsn13.1'></a>Internationale
programmer</SPAN></H2>
<P CLASS="western">N&aring;r et program skal anvendes af flere
kulturer og sprog, opst&aring;r behov for, at programtekster, bel&oslash;b
og dato angives i de p&aring;g&aelig;ldende landes sprog og man m&aring;
i gang med at internationalisere og lokalisere programmet.</P>
<P CLASS="western"><I>Internationalisering</I> (eng.:
Internationalization, ogs&aring; kaldet I18N) best&aring;r i, at g&oslash;re
programmet sprogneutralt, ved at s&oslash;rge for, at al formatering
og fortolkning af tal-, bel&oslash;bs-, dato- og tidsangivelser, sker
afh&aelig;ngigt af sproget og at al sproglig tekst er flyttet til
separate filer. Det er typisk programm&oslash;rens, der st&aring;r
for denne opgave.</P>
<P CLASS="western"><I>Lokalisering</I> (eng.: Localization, ogs&aring;
kaldet L10N) best&aring;r i, at overs&aelig;tte filerne fra
hovedsproget til de andre sprog, applikationen skal fungere p&aring;.
Denne opgave varetages typisk af en professionel overs&aelig;tter.</P>
<H3 CLASS="western">13.1.1 <a name='afsn13.1.1'></a>Formatering af tidspunkter</H3>
<P CLASS="western">DateFormat formaterer Date-objekter til strenge
(og den anden vej).</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormat</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat, dkf;</SPAN>
<SPAN LANG="da-DK"><B>    klformat   = DateFormat.getTimeInstance(DateFormat.MEDIUM);</B></SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.FULL);</SPAN>
<SPAN LANG="da-DK">    dkf = DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.SHORT);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>tid</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Kl   :&quot;+ <B>klformat.format(tid)</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Dato :&quot;+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Tid  :&quot;+ dkf.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Wed Feb 05 14:23:46 GMT+00:00 2003
<SPAN LANG="da-DK">Kl   :14:23:46</SPAN>
<SPAN LANG="da-DK">Dato :5. februar 2003</SPAN>
<SPAN LANG="da-DK">Tid  :05-02-2003 14:23</SPAN></PRE><P CLASS="western">
L&aelig;g for det f&oslash;rste m&aelig;rke til, at toString() p&aring;
Date ikke er lokaliseret. Den b&oslash;r kun bruges til
test-udskrifter og logning og ikke i tekst, som brugeren skal l&aelig;se.
</P>
<P CLASS="western">Ovenst&aring;ende program er k&oslash;rt med
danske sprogindstillinger. Med amerikanske sprogindstillinger bliver
uddata i stedet:</P>
<PRE CLASS="kode-western">Mon Dec 03 13:27:57 GMT+01:00 2001<BR>Kl:   1:27:57 PM<BR>Dato: Monday, December 3, 2001<BR>Tid:  Dec 3, 2001 1:27 PM</PRE><P CLASS="western">
Det ses, at det afh&aelig;nger en del af sproget, pr&aelig;cist
hvordan tider bliver formateret (f.eks. er ugedag med i den
amerikanske tekst, men ikke i den danske).</P>

<P CLASS="western" STYLE="">&Oslash;nsker
man som programm&oslash;r fuld kontrol over, hvordan teksten bliver
formateret, m&aring; man selv specificere formatet med
SimpleDateFormat:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytSimpleDateFormat</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    DateFormat df = new SimpleDateFormat(&quot;EEEE 'den' d. MMMM '&aring;r' yyyy.&quot;);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( df.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">mandag den 3. december &aring;r 2001.</PRE>
<P CLASS="western">Dermed bliver selve formaterings-strengen
sprogspecifik (og den b&oslash;r l&aelig;gges ud i en resursefil - se
senere). K&oslash;res den med amerikanske sprogindstillinger, bliver
uddata:</P>
<PRE CLASS="kode-western">Monday den 3. December &aring;r 2001.</PRE>
<H3 CLASS="western">13.1.2 <a name='afsn13.1.2'></a>Formatering af tal og bel&oslash;b</H3>
<P CLASS="western">P&aring; samme m&aring;de som med tidsangivelser
formateres/fortolkes tal ved at bede om et formateringsobjekt, der
klarer netop denne form for tal:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">public class BenytNumberFormat</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[]) </SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    double <B>tal = 1234.5678</B>;</SPAN>
<SPAN LANG="da-DK">    NumberFormat <B>fmt1 = NumberFormat.getInstance()</B>;</SPAN>
<SPAN LANG="da-DK">    NumberFormat fmt2 = NumberFormat.getCurrencyInstance();</SPAN>
<SPAN LANG="da-DK">    NumberFormat fmt3 = NumberFormat.getPercentInstance();</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>fmt1.format(tal)</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( fmt2.format(tal) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( fmt3.format(tal) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">1.234,568
<SPAN LANG="da-DK">kr 1.234,57</SPAN>
<SPAN LANG="da-DK">123.457%</SPAN></PRE><P CLASS="western">
Med amerikanske sprogindstillinger bliver uddata:</P>
<PRE CLASS="kode-western">1,234.568
<SPAN LANG="da-DK">$1,234.57</SPAN>
<SPAN LANG="da-DK">123,457%</SPAN></PRE>
<H3 CLASS="western">13.1.3 <a name='afsn13.1.3'></a>Bruge Locale-objekter</H3>
<P CLASS="western">Land og sprog (lokalindstillingerne) repr&aelig;senteres
ved et Locale-objekt. Dette objekt bruges til al formatering, til at
finde resursebundter frem og lignende.</P>
<P CLASS="western">&Oslash;nsker man kontrol over hvilket sprog, der
anvendes, kan man selv oprette et Locale-objekt, og det kan s&aring;
bruges til at fremskaffe formateringsobjekter til det p&aring;g&aelig;ldende
sprog:</P>
<PRE CLASS="kode-western" STYLE="">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormat2</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[]) {</SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat;</SPAN>

<SPAN LANG="da-DK">    Locale <B>fransk = new Locale(&quot;fr&quot;,&quot;FR&quot;)</B>;</SPAN>
<SPAN LANG="da-DK">    klformat   = DateFormat.getTimeInstance(DateFormat.SHORT<B>,fransk</B>);</SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.LONG<B>, fransk</B>);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Kl:   &quot;+ klformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Dato: &quot;+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Kl:   14:23
<SPAN LANG="da-DK">Dato: 5 f&eacute;vrier 2003</SPAN></PRE>
<H3 CLASS="western">13.1.4 <a name='afsn13.1.4'></a>De mulige lokalindstillinger</H3>
<P CLASS="western">Man kan unders&oslash;ge hvilke Locale-objekter,
der er tilg&aelig;ngelige, ved at kalde klassemetoden
Locale.getAvailableLocales(). Her er et lille program, der skriver
dem ud:</P>
<PRE CLASS="kode-western">import java.util.*;
<SPAN LANG="da-DK">public class MuligeSprog</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[]) {</SPAN>
<SPAN LANG="da-DK">    Locale[] lokalindstillinger = Locale.getAvailableLocales();</SPAN>
<SPAN LANG="da-DK">    for (int i=0; i&lt;lokalindstillinger.length; i++) {</SPAN>
<SPAN LANG="da-DK">      Locale lokalindst = lokalindstillinger[i];</SPAN>
<SPAN LANG="da-DK">      System.out.print(lokalindst+&quot; &quot;);</SPAN>
<SPAN LANG="da-DK"><I>      // udkomment&eacute;r hvis du vil se hvad sproget hedder p&aring; sproget selv</I></SPAN>
<SPAN LANG="da-DK"><I>      //System.out.println(lokalindst.getDisplayName(lokalindst));</I></SPAN>
<SPAN LANG="da-DK">    }</SPAN>
<SPAN LANG="da-DK">    System.out.println( );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">ar ar_AE ar_BH ar_DZ ar_EG ar_IQ ar_JO ar_KW ar_LB ar_LY ar_MA ar_OM ar_QA ar_SA ar_SD ar_SY ar_TN ar_YE hi_IN iw iw_IL ja ja_JP ko ko_KR th th_TH th_TH_TH zh 
<SPAN LANG="da-DK">zh_CN zh_HK zh_TW be be_BY bg bg_BG ca ca_ES cs cs_CZ da da_DK de de_AT de_CH </SPAN>
<SPAN LANG="da-DK">de_DE de_LU el el_GR en_AU en_CA en_GB en_IE en_IN en_NZ en_ZA es es_AR es_BO </SPAN>
<SPAN LANG="da-DK">es_CL es_CO es_CR es_DO es_EC es_ES es_GT es_HN es_MX es_NI es_PA es_PE es_PR </SPAN>
<SPAN LANG="da-DK">es_PY es_SV es_UY es_VE et et_EE fi fi_FI fr fr_BE fr_CA fr_CH fr_FR fr_LU hr </SPAN>
<SPAN LANG="da-DK">hr_HR hu hu_HU is is_IS it it_CH it_IT lt lt_LT lv lv_LV mk mk_MK nl nl_BE nl_NL </SPAN>
<SPAN LANG="da-DK">no no_NO no_NO_NY pl pl_PL pt pt_BR pt_PT ro ro_RO ru ru_RU sh sh_YU sk sk_SK sl </SPAN>
<SPAN LANG="da-DK">sl_SI sq sq_AL sr sr_YU sv sv_SE tr tr_TR uk uk_UA en en_US eo</SPAN></PRE><P CLASS="western">
Locale-objektet best&aring;r af tre dele:</P>
<UL>
  <LI><P CLASS="western">F&oslash;rste del er sprogkoden, f.eks. da,
  sv, no, en, fr.</P>
  <LI><P CLASS="western">En valgfri anden del er landekoden, f.eks.
  DK, NO, GB, DE, FR</P>
  <LI><P CLASS="western">En valgfri tredje del er varianten inden for
  sprogomr&aring;det (f.eks. om valutaen er i euro).</P>
</UL>
<P CLASS="western">Eksempler:</P>
<P CLASS="western" STYLE="margin-left: 0.5cm">fr: Fransk<BR>fr_BE:
Fransk i Belgien<BR>fr_CA: Fransk i Canada<BR>no_NO: Norsk i Norge
(bokm&aring;l) <BR>no_NO_NY: Nynorsk i Norge (variant NY er nynorsk)</P>
<H2 CLASS="western" STYLE="">13.2 <a name='afsn13.2'></a>Eksempel:
Webside med alle sprog</SPAN></H2>
<P CLASS="western">Her er et eksempel, der sammenfatter det
ovenst&aring;ende og hvor man kan v&aelig;lge mellem alle de mulige
sprog og se hvordan forskellige ting skrives p&aring; dette sprog:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>sprogtest.jsp</I></FONT></P>
<PRE CLASS="kode-western"><SPAN LANG="da-DK">&lt;%@ page import=&quot;java.util.*,java.text.*&quot; <B>contentType=&quot;text/html;charset=UTF-8&quot;</B> %&gt;</SPAN>
<SPAN LANG="da-DK">&lt;html&gt;</SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;Sprogtest&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>

<SPAN LANG="da-DK">&lt;p&gt;</SPAN>Din netl<B>&amp;aelig;</B>sers foretrukne sprog er &lt;%=request.getLocale().getDisplayName()%&gt;
<SPAN LANG="da-DK">&lt;br&gt;Samtlige acceptable sprog er: </SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  Enumeration e = request.getLocales();</SPAN>
<SPAN LANG="da-DK">  while (e.hasMoreElements()) {</SPAN>
<SPAN LANG="da-DK">    Locale l = (Locale) e.nextElement();</SPAN>
<SPAN LANG="da-DK">    out.print(l + &quot;:&quot;+l.getDisplayName()+&quot;\n&quot; );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/p&gt;</SPAN>

<SPAN LANG="da-DK">&lt;p&gt;V<B>&amp;aelig;</B>lg sprog&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">&lt;font size=&quot;-1&quot;&gt;Disse er tilg<B>&amp;aelig;</B>ngelige:</SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  Locale[] lokalindstillinger = Locale.getAvailableLocales();</SPAN>
<SPAN LANG="da-DK">  for (int i=0; i&lt;lokalindstillinger.length; i++) {</SPAN>
<SPAN LANG="da-DK">    Locale lokalindst = lokalindstillinger[i];</SPAN>
<SPAN LANG="da-DK">    out.print(&quot; &lt;a href='sprogtest.jsp?sprog=&quot;+lokalindst+&quot;'&gt;&quot;</SPAN>
<SPAN LANG="da-DK">      +lokalindst+&quot;&lt;/a&gt;:&quot;                     <I>// sprogkode, f.eks.: da_DK</I></SPAN>
<SPAN LANG="da-DK">      +lokalindst.getDisplayName(lokalindst));<I>// fuldt navn paa sproget selv</I></SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/font&gt;&lt;/p&gt;</SPAN>

<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  Locale sprog = request.getLocale();             <I>// netlaeserens foretrukne sprog</I></SPAN>
<SPAN LANG="da-DK">  String vsprog = request.getParameter(&quot;sprog&quot;);  <I>// har bruger valgt et andet?</I></SPAN>
<SPAN LANG="da-DK">  if (vsprog != null) {</SPAN>
<SPAN LANG="da-DK">    String[] s = vsprog.split(&quot;_&quot;);               <I>// split f.eks. da_DK op</I></SPAN>
<SPAN LANG="da-DK">    if (s.length==1) sprog = new Locale(vsprog);        <I>// sprog (da)</I></SPAN>
<SPAN LANG="da-DK">    else if (s.length==2) sprog = new Locale(s[0],s[1]);<I>// sprog, land (da_DK)</I></SPAN>
<SPAN LANG="da-DK">    else sprog = new Locale(s[0],s[1],s[2]);            <I>// sprog, land, variant</I></SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;Ting p<B>&amp;aring;</B> &lt;%= sprog.getDisplayName(sprog) %&gt;&lt;/h1&gt;</SPAN>
<SPAN LANG="da-DK">&lt;pre&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  double tal = 1234.5678;</SPAN>
<SPAN LANG="da-DK">  NumberFormat fmt1 = NumberFormat.getInstance(sprog);</SPAN>
<SPAN LANG="da-DK">  NumberFormat fmt2 = NumberFormat.getCurrencyInstance(sprog);</SPAN>
<SPAN LANG="da-DK">  NumberFormat fmt3 = NumberFormat.getPercentInstance(sprog);</SPAN>
<SPAN LANG="da-DK">  out.println( &quot;Tal             : &quot; + fmt1.format(tal) );</SPAN>
<SPAN LANG="da-DK">  out.println( &quot;Valuta          : &quot; + fmt2.format(tal) );</SPAN>
<SPAN LANG="da-DK">  out.println( &quot;Procent         : &quot; + fmt3.format(tal) );</SPAN>

<SPAN LANG="da-DK">  Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">  out.println( &quot;tid.toString()  : &quot;+ tid );</SPAN>

<SPAN LANG="da-DK">  SimpleDateFormat brugerdefineretFormat = </SPAN>
<SPAN LANG="da-DK">               new SimpleDateFormat(&quot;EEEE 'den' d. MMMM '<B>&amp;aring;</B>r' yyyy.&quot;, sprog);</SPAN>
<SPAN LANG="da-DK">  out.println( &quot;SimpleDateFormat: &quot; + brugerdefineretFormat.format(tid) );</SPAN>

<SPAN LANG="da-DK">  DateFormat klformat, datoformat, dkf;</SPAN>
<SPAN LANG="da-DK">  klformat   = DateFormat.getTimeInstance(DateFormat.MEDIUM, sprog);</SPAN>
<SPAN LANG="da-DK">  datoformat = DateFormat.getDateInstance(DateFormat.FULL, sprog);</SPAN>
<SPAN LANG="da-DK">  dkf = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL, sprog);</SPAN>

<SPAN LANG="da-DK">  ResourceBundle res = ResourceBundle.getBundle(&quot;sprogtest.Tekster&quot;, sprog);</SPAN>

<SPAN LANG="da-DK">  out.println( res.getString(&quot;Kl_&quot;)+ klformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">  out.println( res.getString(&quot;Dato_&quot;)+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">  out.println( res.getString(&quot;Tid_&quot;)+ dkf.format(tid) );</SPAN>
<SPAN LANG="da-DK">%&gt;&lt;/pre&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog14_html_m7965e7bf.png" NAME="Grafik100" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">V&aelig;lger man nu catalansk i Spanien (ca_ES)
f&aring;r man:</P>
<P CLASS="western"><IMG SRC="bog14_html_6ca0eb7.png" NAME="Grafik47" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western" STYLE="">V&aelig;lger man
engelsk i Canada (en_CA) f&aring;r man:</P>
<P CLASS="western"><IMG SRC="bog14_html_69585ab3.png" NAME="Grafik48" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">L&aelig;g m&aelig;rke til, at de nederste tre
tekster (Kl, Dato og Tid) bliver vist p&aring; engelsk (Time of day,
Date og Time). Det skyldes, at disse tekster er blevet lagt ud i en
separat fil (en resursefil), der er blevet oversat til engelsk (se
senere).</P>
<H2 CLASS="western">13.3 <a name='afsn13.3'></a>Tegns&aelig;t og HTML-entiteter</SPAN></H2>
<P CLASS="western">L&aelig;g m&aelig;rke til linjen</P>
<PRE CLASS="kode-western">&lt;%@ page contentType=&quot;text/html;charset=UTF-8&quot; %&gt;</PRE><P CLASS="western">
&oslash;verst i eksemplet. 
</P>
<P CLASS="western">Sidedirektivet her specificerer at HTML-siden
kommer i indkodningen  <SPAN LANG="da-DK">UTF-8, d.v.s. Unicode.
Unicode er n&oslash;dvendigt, for at kunne repr&aelig;sentere tegn
uden for intervallet 0-256, men er ikke kompatibelt ved vestlig
indkodning (ISO-8859-1) uden for ASCII-omr&aring;det (de amerikanske
tegn A-Z), s&aring; &aelig;, &oslash; og &aring; og andre specielle
tegn g&aring;r tabt.</SPAN></P>
<P CLASS="western"><SPAN LANG="da-DK">N&aring;r man </SPAN>skriver
sine websider, m&aring; man derfor enten s&oslash;rge for at siderne
er er indkodet i Unicode-formatet eller benytte HTML-entiteter, s&aring;som
&amp;aelig; (for &aelig;), &amp;oslash; (for &oslash;) og &amp;aring;
(for &aring;) i HTML-koden i stedet. 
</P>
<P CLASS="western">Det har vi gjort i eksemplet, f.eks har vi
skrevet:</P>
<PRE CLASS="kode-western">Din netl&amp;aelig;ser</PRE><P CLASS="western">
i stedet for:</P>
<PRE CLASS="kode-western">Din netl&aelig;ser</PRE>
<H2 CLASS="western">13.4 <a name='afsn13.4'></a>Tekstindhold i resursefiler</SPAN></H2>
<P CLASS="western">Programmet BenytDateFormat er halvt
internationaliseret, da tidsformateringen korrekt skifter afh&aelig;ngigt
af sproget. Der mangler kun strengene &quot;Kl:   &quot;, &quot;Dato:
&quot; og &quot;Tid:  &quot;. 
</P>
<P CLASS="western">Lad os nu fuldf&oslash;re internationaliseringen
ved at l&aelig;gge tekstindholdet (strengene) ud i et resursebundt
<SPAN STYLE="font-weight: medium">(eng.: resource bundle) </SPAN>med
navnet Tekster. 
</P>
<P CLASS="western" STYLE="">Disse kan tilg&aring;s
fra programmet s&aring;ledes:</P>
<PRE CLASS="kode-western">package sprogtest;

<SPAN LANG="da-DK">import java.text.*;</SPAN>
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormatMedResurser</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    <B>ResourceBundle res = ResourceBundle.getBundle(&quot;sprogtest.Tekster&quot;);</B></SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat, dkf;</SPAN>
<SPAN LANG="da-DK">    klformat   = DateFormat.getTimeInstance(DateFormat.MEDIUM);</SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.FULL);</SPAN>
<SPAN LANG="da-DK">    dkf = DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.SHORT);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Kl_&quot;)</B>+ klformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Dato_&quot;)</B>+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Tid_&quot;)</B>+ dkf.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Kl  : 14:23:50
<SPAN LANG="da-DK">Dato: 5. februar 2003</SPAN>
<SPAN LANG="da-DK">Tid : 05-02-2003 14:23</SPAN></PRE>
<P CLASS="western">Resursebundtet, der skal ligge i filen
sprogtest.Tekster.properties, indeholder teksten i n&oslash;gle-v&aelig;rdi-par.
</P>
<P CLASS="western">Disse vil blive brugt, hvis der ikke findes
resursefiler for det p&aring;g&aelig;ldende sprog:</P>
<PRE CLASS="kode-western">Tid_=Tid  \:
<SPAN LANG="da-DK">Kl_=Kl   \:</SPAN>
<SPAN LANG="da-DK">Dato_=Dato \:</SPAN></PRE><P CLASS="western">
K&oslash;res programmet (p&aring; et styresystem indstillet til
dansk), f&aring;s samme udskrift som f&oslash;r.</P>
<P CLASS="western">Lad os nu lokalisere programmet til engelsk. 
</P>
<P CLASS="western">Det best&aring;r i, at vi opretter
sprogtest.Tekster<B>_en</B>.properties med de engelske tekster:</P>
<PRE CLASS="kode-western">Tid_=Time       \:
<SPAN LANG="da-DK">Kl_=Time of day\:</SPAN>
<SPAN LANG="da-DK">Dato_=Date       \:</SPAN></PRE>
<P CLASS="western">Starter vi derefter programmet med engelske
sprogindstillinger, f&aring;r vi uddata:</P>
<PRE CLASS="kode-western">Time of day : 3:07:28 PM
<SPAN LANG="da-DK">Date        : Monday, December 3, 2001</SPAN>
<SPAN LANG="da-DK">Time        : Dec 3, 2001 3:07 PM</SPAN></PRE><H3 CLASS="western">
13.4.1 <a name='afsn13.4.1'></a>Hvordan der s&oslash;ges efter resurser</H3>
<P CLASS="western">N&aring;r programmet skal finde en programtekst ud
fra sprogindstillingerne, sker det ved f&oslash;rst at kigge i den
mest specifikke resursefil. Hvis programteksten ikke findes der,
kigges i en mere generel resursefil og til sidst i den mest
generelle. 
</P>
<P CLASS="western">For eksempel vil resurser til sproget fr_CA
(canadisk fransk) blive s&oslash;gt</P>
<OL>
  <LI><P CLASS="western">f&oslash;rst i     Tekster_fr_CA.properties</P>
  <LI><P CLASS="western">dern&aelig;st i   Tekster_fr.properties</P>
  <LI><P CLASS="western">og sidst i   Tekster.properties</P>
</OL>
<H3 CLASS="western">13.4.2 <a name='afsn13.4.2'></a>Avanceret: Bin&aelig;re resursefiler</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel13.jsp#afsn13.4.2">
  <input type='checkbox' name='vis' value='13.4.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='13.4.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">13.4.3 <a name='afsn13.4.3'></a>Avanceret tekstformatering</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel13.jsp#afsn13.4.3">
  <input type='checkbox' name='vis' value='13.4.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='13.4.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">13.5 <a name='afsn13.5'></a>En international f&aelig;lleskalender</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel13.jsp#afsn13.5">
  <input type='checkbox' name='vis' value='13.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='13.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H3 CLASS="western">13.5.1 <a name='afsn13.5.1'></a>Slutbrugerens oplevelse</H3>
<P CLASS="western">Her ses kalenderen p&aring; dansk og tysk:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog14_html_311d8ce0.png" NAME="Grafik40" ALIGN=BOTTOM BORDER=0>
 
<IMG SRC="bog14_html_58570bda.png" NAME="Grafik101" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western"><SPAN LANG="da-DK">Her er vist redigering p&aring;
sproget esperanto:</SPAN></P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog14_html_m5a061f0a.png" NAME="Grafik49" ALIGN=BOTTOM BORDER=0></P>
<H3 CLASS="western">13.5.2 <a name='afsn13.5.2'></a>Fuld separation mellem layout og sprog</H3>
<P CLASS="western">Eksemplet g&oslash;r brug af resursebundter til
samtlige programtekster og opn&aring;r derved, at JSP-siden kun
besk&aelig;ftiger sig med layout og visningslogik.</P>
<P CLASS="western">Overs&aelig;ttelseskoden (opslag i resursebundter)
er lagt i en separat fil, nemlig i en Sprogdata-b&oslash;nne, s&aring;dan
at JSP-siden kan holdes overskuelig og s&aring;dan, at den er s&aring;
lidt forstyrret af opslag i resursebundter som muligt (hver gang en
tekstbid skal ind i JSP-siden kalder den metoden ovs() p&aring;
b&oslash;nnen med n&oslash;glen).</P>
<P CLASS="western">Her er kalendertekster.properties, med
originalsproget (dansk):</P>
<PRE CLASS="kode-western"><I># Filnavn: kalendertekster.properties</I>
<SPAN LANG="da-DK">F&aelig;lleskalender_for=F&aelig;lleskalender for</SPAN>
<SPAN LANG="da-DK">kalenderen=kalenderen</SPAN>
<SPAN LANG="da-DK">kalender=kalender</SPAN>
<SPAN LANG="da-DK">m&aring;ned=m&aring;ned</SPAN>
<SPAN LANG="da-DK">forrige=forrige</SPAN>
<SPAN LANG="da-DK">n&aelig;ste=n&aelig;ste</SPAN>
<SPAN LANG="da-DK">redig&eacute;r=redig&eacute;r</SPAN>
<SPAN LANG="da-DK">vis=vis</SPAN>
<SPAN LANG="da-DK">Tryk_input_type_submit_value_OK_n&aring;r_du_vil_gemme_&aelig;ndringer=Tryk &lt;input type='submit' value='OK'&gt; n&aring;r du vil gemme &aelig;ndringer</SPAN>
<SPAN LANG="da-DK">_input_type_submit_value_OK_=&lt;input type='submit' value='OK'&gt;</SPAN></PRE>
<P CLASS="western">Her er kalendertekster_de.properties (tysk):</P>
<PRE CLASS="kode-western"><I># Filnavn: kalendertekster_de.properties</I>
<SPAN LANG="da-DK">F&aelig;lleskalender_for=Der Gruppenkalender f&uuml;r</SPAN>
<SPAN LANG="da-DK">kalenderen=der Kalender</SPAN>
<SPAN LANG="da-DK">kalender=Kalender</SPAN>
<SPAN LANG="da-DK">m&aring;ned=monat</SPAN>
<SPAN LANG="da-DK">forrige=vorheriger</SPAN>
<SPAN LANG="da-DK">n&aelig;ste=n&auml;chste</SPAN>
<SPAN LANG="da-DK">redig&eacute;r=redigieren</SPAN>
<SPAN LANG="da-DK">vis=zeigen</SPAN>
<SPAN LANG="da-DK">Tryk_input_type_submit_value_OK_n&aring;r_du_vil_gemme_&aelig;ndringer=Dr&uuml;cken &lt;input type='submit' value='OK'&gt; um die &Auml;nderungen zu speichern</SPAN>
<SPAN LANG="da-DK">_input_type_submit_value_OK_=&lt;input type='submit' value='OK'&gt;</SPAN></PRE>
<P CLASS="western">Her er kalendertekster_eo.properties (esperanto):</P>
<PRE CLASS="kode-western"><I># Filnavn: kalendertekster_eo.properties</I>
<SPAN LANG="da-DK">F&aelig;lleskalender_for=Komuna kalendaro por</SPAN>
<SPAN LANG="da-DK">kalenderen=la kalendaro</SPAN>
<SPAN LANG="da-DK">kalender=kalendaro</SPAN>
<SPAN LANG="da-DK">m&aring;ned=monato</SPAN>
<SPAN LANG="da-DK">forrige=antaua</SPAN>
<SPAN LANG="da-DK">n&aelig;ste=posta</SPAN>
<SPAN LANG="da-DK">redig&eacute;r=redaktu</SPAN>
<SPAN LANG="da-DK">vis=montru</SPAN>
<SPAN LANG="da-DK">Tryk_input_type_submit_value_OK_n&aring;r_du_vil_gemme_&aelig;ndringer=Premu &lt;input type='submit' value='Bone'&gt; por konservi shanghojn</SPAN>
<SPAN LANG="da-DK">_input_type_submit_value_OK_=&lt;input type='submit' value='Bone'&gt;</SPAN></PRE>

<P CLASS="western" STYLE="">Her er
javab&oslash;nnen Sprogdata, der holder styr p&aring; sprog og
resursebundter:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Sprogdata.java</I></FONT></P>
<PRE CLASS="kode-western">package kalender;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">import java.text.*;</SPAN>

<SPAN LANG="da-DK">public class Sprogdata</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  private Locale sprog = Locale.getDefault();</SPAN>
<SPAN LANG="da-DK">  private ResourceBundle tekster;</SPAN>
<SPAN LANG="da-DK">  private Bruger bruger;</SPAN>

<SPAN LANG="da-DK">  public void setLocale(Locale sproget) </SPAN>
<SPAN LANG="da-DK">  { </SPAN>
<SPAN LANG="da-DK">    sprog = sproget;</SPAN>
<SPAN LANG="da-DK">    tekster = ResourceBundle.getBundle(&quot;kalendertekster&quot;,sprog);</SPAN>
<SPAN LANG="da-DK">    bruger.setLocale(sprog);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK">  public void setBruger(Bruger brugerobjekt)</SPAN>
<SPAN LANG="da-DK">  { </SPAN>
<SPAN LANG="da-DK">    bruger = brugerobjekt; </SPAN>
<SPAN LANG="da-DK">    bruger.setLocale(sprog);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK">  public void setSprog(String sproget) {</SPAN>
<SPAN LANG="da-DK">    String[] s = sproget.split(&quot;_&quot;);</SPAN>
<SPAN LANG="da-DK">    if (s.length==1) setLocale(new Locale(sproget)); </SPAN>
<SPAN LANG="da-DK">    else if (s.length==2) setLocale(new Locale(s[0],s[1])); </SPAN>
<SPAN LANG="da-DK">    else setLocale(new Locale(s[0],s[1],s[2])); </SPAN>
<SPAN LANG="da-DK">  }</SPAN>

<SPAN LANG="da-DK"><I>  /** Overs&aelig;t en tekst (sl&aring; op i det relevante resursebundt) */</I></SPAN>
<SPAN LANG="da-DK">  public String ovs(String n&oslash;gle)</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    try {</SPAN>
<SPAN LANG="da-DK">      return tekster.getString(n&oslash;gle);</SPAN>
<SPAN LANG="da-DK">    } catch (MissingResourceException e) </SPAN>
<SPAN LANG="da-DK">    {</SPAN>
<SPAN LANG="da-DK">      System.err.println(&quot;Advarsel: Manglende resurse i kalendertekster:\n&quot;</SPAN>
<SPAN LANG="da-DK">          + n&oslash;gle.replaceAll(&quot;[\\p{Punct}\\s]+&quot;,&quot;_&quot;)  <I>// erstat andre tegn med _</I></SPAN>
<SPAN LANG="da-DK">          + &quot;=&quot; + n&oslash;gle.replaceAll(&quot;[\r\n]&quot;,&quot;\\\n&quot;) );</SPAN>
<SPAN LANG="da-DK">      return n&oslash;gle;</SPAN>
<SPAN LANG="da-DK">    }</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>

<P CLASS="western" STYLE="">Her er JSP-siden
med kalenderen:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>kalender.jsp</I></FONT></P>
<PRE CLASS="kode-western"><I>&lt;%-- Knyt b&oslash;nnen Bruger til brugerens session under navnet b --%&gt;</I>
&lt;jsp:useBean id=&quot;b&quot; class=&quot;kalender.Bruger&quot; scope=&quot;session&quot; /&gt;
<SPAN LANG="da-DK"> </SPAN><FONT COLOR="#d9d9d9"><FONT FACE="Courier, monospace"><FONT SIZE=1 STYLE="font-size: 2pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><SPAN LANG="da-DK">&lt;%-- &lt;title&gt;kalender&lt;/title&gt; --%&gt;</SPAN></SPAN></SPAN></FONT></FONT></FONT>
<SPAN LANG="da-DK"><I>&lt;%-- Overf&oslash;r parametre til b, der svarer til egenskaber --%&gt;</I></SPAN>
&lt;jsp:setProperty name=&quot;b&quot; property=&quot;*&quot; /&gt;

<SPAN LANG="da-DK"><I>&lt;%-- Knyt b&oslash;nnen Sprogdata til brugerens session under navnet s --%&gt;</I></SPAN>
<SPAN LANG="da-DK"><B>&lt;jsp:useBean id=&quot;s&quot; class=&quot;kalender.Sprogdata&quot; scope=&quot;session&quot;&gt;</B></SPAN>
<I>  <B>&lt;%</B> // F&oslash;rste gang: Knyt til Bruger-objekt og registr&eacute;r spr</I>oget 
<B>    s.setBruger( b );</B>
<SPAN LANG="da-DK"><B>    s.setLocale( request.getLocale() ); %&gt;</B></SPAN>
<SPAN LANG="da-DK"><B>&lt;/jsp:useBean&gt;</B></SPAN>

<SPAN LANG="da-DK"><I>&lt;%-- Overf&oslash;r evt. sprog-parameter til s --%&gt;</I></SPAN>
<SPAN LANG="da-DK"><B>&lt;jsp:setProperty name=&quot;s&quot; property=&quot;sprog&quot; /&gt;</B></SPAN>

<SPAN LANG="da-DK">&lt;html&gt;      <I>&lt;%-- s.ovs() overs&aelig;tter teksten til det p&aring;g&aelig;ldende sprog --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;<B>&lt;%= s.ovs(&quot;kalender&quot;) %&gt;</B>&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>

<SPAN LANG="da-DK">[<B>&lt;a href='kalender.jsp?sprog=da'&gt;dansk&lt;/a&gt; - </B></SPAN>
<SPAN LANG="da-DK"><B> &lt;a href='kalender.jsp?sprog=de'&gt;Deutsch&lt;/a&gt; -</B></SPAN>
<SPAN LANG="da-DK"><B> &lt;a href='kalender.jsp?sprog=eo'&gt;Esperanto&lt;/a&gt;</B>]</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;<B>&lt;%= s.ovs(&quot;F&aelig;lleskalender_for&quot;) %&gt;</B> &lt;%= b.getDatostr() %&gt;&lt;/h1&gt;</SPAN>

<SPAN LANG="da-DK">&lt;a href=&quot;kalender.jsp?maaned=&lt;%= b.getMaaned()-1 %&gt;&quot;&gt;<B>&lt;%= s.ovs(&quot;forrige&quot;) %&gt;</B>&lt;/a&gt;</SPAN>
<SPAN LANG="da-DK">  <B>&lt;%= s.ovs(&quot;m&aring;ned&quot;) %&gt;</B> -</SPAN>
<SPAN LANG="da-DK">&lt;a href=&quot;kalender.jsp?maaned=&lt;%= b.getMaaned()+1 %&gt;&quot;&gt;<B>&lt;%= s.ovs(&quot;n&aelig;ste&quot;) %&gt;</B>&lt;/a&gt;</SPAN>
<SPAN LANG="da-DK">  <B>&lt;%= s.ovs(&quot;m&aring;ned&quot;) %&gt;</B> -</SPAN>

<SPAN LANG="da-DK">&lt;% </SPAN>
<SPAN LANG="da-DK">  if (b.isRediger()) { <I>// redigering - vis en input-formular</I></SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;a href=&quot;kalender.jsp?rediger=false&quot;&gt;<B>&lt;%= s.ovs(&quot;vis&quot;) %&gt;</B>&lt;/a&gt;</SPAN>
<SPAN LANG="da-DK">    <B>&lt;%= s.ovs(&quot;kalenderen&quot;) %&gt;</B>.&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;br&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;form action=&quot;kalender.jsp&quot; method=&quot;post&quot;&gt;</SPAN>
<SPAN LANG="da-DK">    <B>&lt;%=s.ovs(&quot;Tryk_input_type_submit_value_OK_n&aring;r_du_vil_gemme_&aelig;ndringer&quot;)%&gt;</B>.&lt;br&gt;</SPAN>

<SPAN LANG="da-DK">    &lt;% b.udskrivDagsprogram(out); %&gt;</SPAN>

<SPAN LANG="da-DK">    &lt;br&gt;&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">    <B>&lt;%= s.ovs(&quot;_input_type_submit_value_OK_&quot;) %&gt;</B></SPAN>
<SPAN LANG="da-DK">  &lt;/form&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  } else {             <I>// fremvisning</I></SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;a href=&quot;kalender.jsp?rediger=true&quot;&gt;<B>&lt;%= s.ovs(&quot;redig&eacute;r&quot;) %&gt;</B>&lt;/a&gt;</SPAN>
<SPAN LANG="da-DK">    <B>&lt;%= s.ovs(&quot;kalenderen&quot;) %&gt;</B>.&lt;br&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;% b.udskrivDagsprogram(out); %&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">  } </SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE><P CLASS="western">
<SPAN LANG="da-DK">Sammenlign med kalender.jsp i <a href='kapitel9.jsp#afsn9.4.3'>afsnit 9.4.3</a>
(&aelig;ndringer er markeret med fed).</SPAN></P>
<H2 CLASS="western">13.6 <a name='afsn13.6'></a>Y<SPAN LANG="da-DK">derligere l&aelig;sning</SPAN></SPAN></H2>
<P CLASS="western">Om internationalisering af JSP-sider:</P>
<P CLASS="western"><SPAN LANG="da-DK">
</SPAN><A CLASS="western" HREF="http://java.sun.com/webservices/docs/1.3/tutorial/doc/WebI18N.html"><SPAN LANG="da-DK">http://java.sun.com/webservices/docs/1.3/tutorial/doc/WebI18N.html</SPAN></A></P>
<P CLASS="western">Generelt om Java og internationalisering:</P>
<P CLASS="western"> <A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/i18n/">http://java.sun.com/docs/books/tutorial/i18n/</A>
</P>
<P CLASS="western"><SPAN LANG="da-DK">Liste over alle sprog- og
landekoder kan du se i <a href='kapitel13.jsp#afsn13.1.4'>afsnit 13.1.4</a> og <a href='kapitel13.jsp#afsn13.2'>afsnit 13.2</a></SPAN>.</P>

<H1 CLASS="heading1a-western" STYLE="">Stikordsregister</H1>
<MULTICOL ID="Alphabetical Index1" COLS=2 GUTTER=13 <a name='afsn13'></a>STYLE="background: transparent">
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;h1&gt;
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;img&gt;
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>A</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">anmode
  om en side  19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">antialias
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Apache
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ASP
   25</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">attributter
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>B</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">billede
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">billedtekst
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blande
  Java og HTML  33</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blivende
  variabler  38</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blok
   31</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blokparenteser
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Borland
  JBuilder  21</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">browser
   18, 34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">BufferedImage
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>C</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">catch
  without try  34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">content
  type  40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CSS
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>D</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">data
  om klienten  34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dato
   29</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>E</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Eclipse
   22</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">else
  without if  34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">esperanto
   15</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>F</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fil
   37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Forte
   21</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">funktioner
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>G</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">generere
  grafik  40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getAttribute()
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getContextPath()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getGraphics()
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getHeader()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getLocale()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getMethod()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getProtocol()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRealPath()
   37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRemoteAddr()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRequestURL()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getServerName()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getServerPort()
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getServletPath()
   34, 37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GIF
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grafik
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Graphics2D
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>H</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hardisk
   37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>I</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">IBM
  WebSphere Studio  22</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">IIS
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">IllegalStateException
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">image/jpeg
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">import
   32</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indholdstypen
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">int
   30</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>J</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">J2SE
   23, 25</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Jakarta
  Tomcat  23</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java
   28</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java
  Server Pages  19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JAVA_HOME
   24</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">javabog.dk
   15</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JavaScript
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JBuilder
   21</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDeveloper
   20</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDK
  (Java Developers Kit)  23, 25</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JPEGImageEncoder
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JPG
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JRE
  (Java Runtime Environment)  25</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JSP
  (Java Server Pages)  19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">jspInit()
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JSTL
  (JSP Standard Tag Library)  29</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>K</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kommentarer
   35</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Konqueror
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>L</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Linux
   15, 18</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>M</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Mandrake
  Linux  15</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mappe
   37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metoder
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MIME-type
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>N</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NetBeans
   21</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">netl&aelig;ser
   18, 34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">netudgave
   15</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">netudgaven
  af bogen  15</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NoClassDefFoundError
   24</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>O</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objekt
   31</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Open
  Source  15, 21, 23</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">OpenOffice.org
   15</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Oracle
   20</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">out-objektet
   29</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>P</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">parameter
   42</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">PHP
   25</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">platformsuafh&aelig;ngig
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">PNG
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">println()
   28, 29</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">procedurer
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">producere
  grafik  40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pr&oslash;ve
  eksempler  29</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>R</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">reference-implementering
   23</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">regneudtryk
   30</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RenderingHints
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">request
   19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">request-objektet
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Resin
   25</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>S</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">se
  filer p&aring; serveren  37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">serverens
  hardisk  37</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">serverside-teknologi
   19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ServletOutputStream
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">setContentType()
   42</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">side-direktivet
   32</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">slut-kode
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sprog
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">subrutiner
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Sun
  Java Studio Creator  21</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">synchronized
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>T</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tags
   18</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">text/html
   40</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tidspunkt
   29</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tildeling
   30</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Tomcat
   23</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">trappeudj&aelig;vning
   41</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">try
  without catch  34</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tr&aring;dsikkerhed
   39</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">typografi
   26</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>U</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">udtryk
   31</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">udviklingsv&aelig;rkt&oslash;j
   20, 23</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">undervisningspakke
   14</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URL
   19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">user-agent
   34</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>V</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">variabler
   30, 38</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;form&gt;
   49, 50, 52, 53</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;input&gt;
   49, 53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:forward
  /&gt;  77, 78, 79</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:getProperty
  /&gt;  168</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:include
  /&gt;  79</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:param
  /&gt;  78</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:plugin
  /&gt;  79</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:setProperty
  /&gt;  167, 170, 204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;jsp:useBean
  /&gt;  164, 169, 170</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;option&gt;
   53</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;script&gt;
   78, 157, 158</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;select&gt;
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&lt;textarea&gt;
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>A</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">absolut
  URL  51</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">action-attribut
   50, 52</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">addCookie()
   62, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">adgangskontrol
   73, 149, 179</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afkode
  billede  44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afkode
  parameter  49</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afkrydsningsfelt
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afslut
  behandling af side  203</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">anmode
   65</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Apache
  Axis  229, 230, 232</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">application-objektet
   83</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">applikationsstyret
  adgangskontrol  150</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ASP
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">associative
  afbildninger  300</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">attribut
   50, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">avatar
   43</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>B</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">balancerede
  blokparenteser  87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bankkonti
   196</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">batch
   107</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bel&oslash;b
   264</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">beskyttede
  sider  75</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">beskyttet
  side  145, 151, 155, 156, 179, 188</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">biblioteker
   89</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">billede
   43, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">binding
  af servlet til URL  139</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blokparenteser
   87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">brugeroprettelse
   186</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">b&oslash;nnestyret
  persistens (BMP)  250, 252</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>C</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CachedRowSet
   92, 110</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CallableStatement
   107</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">catch
  without try  87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">certifikat
   148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ClassCastException
   170</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CLASSPATH
   89</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">config-objektet
   84</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Connection
   98</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">connection
  pool  108</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">containerstyret
  adgangskontrol  150</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">containerstyret
  persistens (CMP)  250, 252</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">content
  syndication  219</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">controller
  (MVC)  194</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">cookie
   62, 67, 72, 80, 157, 158, 179</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CORBA
   228, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CREATE
  TABLE  93, 99, 102, 105</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">createStatement()
   98, 100</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">cross-site
  scripting  157</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>D</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">databasedriver
   88, 97, 106</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DCOM
   228</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">De
  Gule Sider  229</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">del
  og hersk  87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DELETE
   93, 99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">deploy
   241</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">deployment
  descriptor  252</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dispatcher
   205</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dokumenttypedefinition
   215</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DOM
  (Document Object Model)  213, 215</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DOM-tr&aelig;
   213, 214</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">driftsbeskrivelse
   142, 143</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DriverManager
   98</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DROP
  TABLE  93, 99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DTD
  (Document Type Definition)  215</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dynamiske
  hjemmesider  47</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>E</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">egenskaber
   166, 167, 171, 176, 179, 197</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">EJB
  Query language  255</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">EJB-container
   241</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ejb-jar.xml
   242, 252</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ekspedit&oslash;r
   205</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">EL
  (Expression Language)  118, 119, 300</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">else
  without if  87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">encodeURL()
   72</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Enterprise
  JavaBean (EJB)  239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">entitetsb&oslash;nner
  (EJB)  246, 250, 254</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">enumeration
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">epost
   184, 186, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">errorPage
   79, 204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">escapeXml
   120</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">esperanto
   53, 272, 273, 275</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">esperanto-dansk-ordbog
   302</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">events
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">exception-objektet
   85, 204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">executeQuery()
   99, 100</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">executeUpdate()
   99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Expression
  Language  118, 300</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>F</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fejlfinding
   87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fejlh&aring;ndtering
   204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fejlmeddelelse
   87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FilteredRowSet
   111</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">filtrering
  af ulovlige tegn  159</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">findByPrimaryKey()
  (EJB)  251, 255</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fjerninterface
  (EJB)  240</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">flette
  XML-dokument  214</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forbindelsespulje
   108</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FORM-baseret
  login  154</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formatering
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formular
   49</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formularfelt
   53</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forretningslogik
   192, 196, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forward()
   78, 203</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">framework
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fremfindingsmetode
  (EJB)  251, 255</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">frontkontrol
   205</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>G</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Gecko
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">genereret
  servlet  139</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GET-metoden
   61, 66</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getAttribute()
   43, 71, 82, 83</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getConnection()
   98</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getContextPath()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getCookies()
   63, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getInitParameter()
   83, 84</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getLocale()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getMethod()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getParameter()
   47, 55, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getParameterNames()
   55, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getParameterValues()
   55, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getProtocol()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRealPath()
   43, 44, 83</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRemoteAddr()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRequestDispatcher()
   78, 203</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getRequestURL()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getServerName()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getServletPath()
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getUserPrincipal()
   156</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Google
   229, 231</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">g&aelig;stebog
   102, 103, 160</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>H</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HashMap
   300</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hexadecimal
  repr&aelig;sentation  59</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hijacking
   158</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hjemmeinterface
  (EJB)  240, 251</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">host
  name  80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML
   212</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML-entitet
   119, 159</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML-formular
   49</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML-injektion
   157, 158</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTTP-anmodning
   61, 65</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTTP-header
   44, 66</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTTP-protokollen
   61, 65, 77, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTTPS
   148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">h&aelig;ndelser
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>I</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">I18N
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">image/jpeg
   42, 66, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">implicitte
  objekter  80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indekserede
  egenskaber  171, 177</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indholdssyndikering
   219</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indholdstypen
   66, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indkode
  data i en URL  59</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indkode
  parameter  49, 59</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Indsend-knap
   50, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indsende
  formular  50</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indtastningsfelt
   49, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">initialiseringsparametre
   83, 161, 184</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">injektion
   157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">inkludering
  af kodefragment  75</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">inklusions-direktivet
   77, 79</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">INSERT
   99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">INSERT
  INTO  93, 104</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">installere
   142</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">interaktive
  hjemmesider  47</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">internationalisering
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">invalidate()
   82</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">invoker
  servlet  139</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">IP-adresse
   43, 44, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>J</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">J2EE
   239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JAASRealm
   152</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Jakarta
  Struts  209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JAR-filer
   89, 130, 142, 146, 188</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java
  2 Enterprise Edition  239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.sql
   97, 99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Javab&oslash;nner
   164, 170, 174, 197</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JavaMail
   184, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JavaScript
   78, 157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDBC
   92, 97, 106, 258</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDBCRealm
   152, 153, 154</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JdbcRowSet
   110</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDeveloper
   95, 139, 229, 230, 231, 248</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JIT
  (Just In Time)  141</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JNDI
   242</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JNDIRealm
   152</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JoinRowSet
   111</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JPEGImageDecoder
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JSESSIONID
   64</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JSF
  (Java Server Faces)  209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JSTL
  (JSP Standard Tag Library)  117</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JTS
  (Java Transaction Service)  258</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>K</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kalender
   175, 275</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kassere
  en session  72</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">keystore
   148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klassebibliotek
   89</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klient-omdirigering
   77</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">knap
   50</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kodefelt
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Konqueror
   44, 53</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kontroll&oslash;r
  (MVC)  193, 194, 196, 202</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kryptering
   148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kultur
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">k&oslash;re
  eksemplerne  47</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>L</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lagdelt
  applikation  192</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">libraries
   89</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Linux
   44, 53, 87, 149</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">livscyklus
  for JSP-sider  141</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Locale
   264</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logfiler
   87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logge
  en fejl  83, 87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logge
  ind  74, 150, 152, 154, 179, 185, 199</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lokale
  interfaces (EJB)  245</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lokalindstillinger
   264</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lokalisering
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>M</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">meddelelses-drevne
  b&oslash;nner (EJB)  247</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MemoryRealm
   152</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metodekald
  over netv&aelig;rk  227</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MIME-type
   66, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">model
  (MVC)  193, 194, 196</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">model
  2-arkitektur  193</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Model-View-Controller
   192, 193</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Mozilla
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MSIE
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MVC
   193, 196, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MySQL
   92, 93, 97, 256</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>N</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nedskalere
  billede  43</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NetBeans
   139</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">netl&aelig;ser
   43, 49, 66</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Netscape
   44, 220</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">No
  suitable driver  88</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NoClassDefFoundError
   88</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nulstille
  formular  57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nyheder
   219, 226</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gle
   301</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;glefil
   148</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>O</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">offentlig
  n&oslash;gle  148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">omdirigere
   77, 81, 157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Open
  Source  92</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Opera
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">opload
  af filer  44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">opremsning
   80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">oprette
  brugere  186</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">oprette
  tabel  93</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">optimering
   101, 106</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Oracle
   95, 98, 253</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">out-objektet
   81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">overs&aelig;t
   274</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>P</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">page-objektet
   85</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pageContext-objektet
   85</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">parameter
   47, 49, 50, 55, 59, 80, 119, 157, 167</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">persistens
   111, 246, 250</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">popup-vindue
   157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">POST-metoden
   61, 66</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">postserver
   184</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">prepareStatement()
   100, 101</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">println()
   81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">privat
  n&oslash;gle  148</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">privilegier
   150</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">programtekst
   263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">properties
   166</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pr&aelig;sentation
  (MVC)  193, 194</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pr&aelig;sentationslogik
   192</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>R</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">radioknapper
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RDF
   220</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">realm
   152</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">remote
  interface (EJB)  240</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Remote
  Method Invocation  228</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">request
   65</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">request-objektet
   47, 80</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Resin
   139</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">response
   65</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">response-objektet
   81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ResultSet
   99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">resursefil
   268, 269</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">return
   203</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RMI
  (Remote Method Invocation)  228</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">roller
   150, 152, 153, 156</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RowSet
   92, 110, 114</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RSS
   220, 222, 225, 226</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>S</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SAX
   215</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">scope
   119, 164, 169</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SELECT
   93, 99, 103, 105</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">semesterplan
   14</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sende
  epost  184</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sendRedirect()
   75, 77, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">serialisering
   219, 227</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">server-omdirigering
   78, 205</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">serverobjekt
   227</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">servlet
   135, 142, 204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">servlet-filter
   158</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">session-objektet
   71, 82</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sessionsb&oslash;nner
  (EJB)  245</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sessionscookie
   63, 64</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sessionskapring
   157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">setAttribute()
   71, 82, 83</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">setContentType()
   81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">side-direktivet
   79, 85, 204</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sikkerhed
   78, 100, 119, 151, 157, 184, 186</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skalere
  billede  43</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skjule
  parametre  61</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skjult
  felt  57, 60, 283</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Slashdot
   224</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SOAP
   228, 234</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sprog
   66, 80, 263</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sprogindstillinger
   264</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SQL
   92, 95</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SQL-injektion
   100, 157, 184</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SQLException
   98</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SSL
  (Secure Socket Layer)  148, 154</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stakspor
   87</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">statefull
  session bean (EJB)  246</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Statement
   98</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stored
  procedures  107</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Struts
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stub
   227</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">submit
   50</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Sun
  Microsystems  228</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">syndikering
   219, 224</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>T</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">taglib
   79, 117, 222, 289</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tekstfelt
   53</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tekstomr&aring;de
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">text/html
   42, 66, 81</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tilf&oslash;je
  parametre  78</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tilstandsfuld
  sessionsb&oslash;nne  246</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tilstandsl&oslash;s
  protokol  61</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Tomcat
   131, 139, 142</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tomcat-users.xml
   151</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transaktion
   258</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transformere
  XML  127, 214</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transportgaranti
   154</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">trelagsmodellen
   192</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">try
  without catch  87</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>U</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">UDDI
   228, 229</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ulovlige
  tegn  157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">UPDATE
   93, 99</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">upload
  af filer  44</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URL
   47</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URL
  Rewriting  72</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URLEncoder
   42, 59</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">user-agent
   44, 65, 66</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>V</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">valgliste
   53, 57</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">veksler
   244</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">view
  (MVC)  194</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">View
  Source  28</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">virkefelt
   119, 164, 169</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">vis
  kilde  28, 61</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>W</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">WAR-fil
   142</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">web
  browser  18, 19</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">WEB-INF
   137, 138, 142, 206</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">web.xml
   83, 138, 142, 143, 184, 206</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webapplikation
   15, 24, 89, 142, 143</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webarkitektur
   209</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webhotel
   19, 26</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">WebRowSet
   112</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webservere
   23, 239</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webtjenester
   228, 235</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Windows
   44, 97</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">WSDL
   228, 229, 231, 232</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>X</B></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XML
   112, 127, 178, 212, 216, 219, 220, 228</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XML
  Schema  215</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XML-format
   212</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XML-transformering
   127, 214</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XMLEncoder
   178, 219</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XPath
   214, 216, 220, 223</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XPathAPI
   218</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XSL
  (XML Style Sheet Language)  214</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">XSS
  (cross-site scripting)  157</FONT></FONT></P>
  <P STYLE="margin-top: 0.06cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">&oslash;nskeseddel
   71, 165</FONT></FONT></P>
</MULTICOL>



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
